-- Test decimal to hex and base conversion functions
-- Test -ve nos, 0, +ve numbers, error values e.g. non hex chars, invalid base chars.
SET SERVEROUTPUT ON SIZE 1000000
DECLARE 
  v_base_string VARCHAR2(15);
  v_base INTEGER;
  v_decimal INTEGER;
BEGIN 

  v_decimal :=NULL;
  v_base_string := util_numeric.dectohex(v_decimal);
  dbms_output.put_line('DECTOHEX Decimal = NULL' || to_char(v_decimal) || ' Hex = ' || v_base_string);
  
  v_decimal :=0;
  v_base_string := util_numeric.dectohex(v_decimal);
  dbms_output.put_line('DECTOHEX Decimal = ' || to_char(v_decimal) || ' Hex = ' || v_base_string);
  
  v_decimal :=-1;
  v_base_string := util_numeric.dectohex(v_decimal);
  dbms_output.put_line('DECTOHEX Decimal = ' || to_char(v_decimal) || ' Hex = ' || v_base_string);
  
  v_decimal :=1000;
  v_base_string := util_numeric.dectohex(v_decimal);
  dbms_output.put_line('DECTOHEX Decimal = ' || to_char(v_decimal) || ' Hex = ' || v_base_string);
  
  v_base_string := NULL;
  v_decimal := util_numeric.hextodec(v_base_string);
  dbms_output.put_line('HEXTODEC Hex = NULL' || v_base_string || ' Decimal = ' || to_char(v_decimal));
  
  v_base_string := '0';
  v_decimal := util_numeric.hextodec(v_base_string);
  dbms_output.put_line('HEXTODEC Hex = ' || v_base_string || ' Decimal = ' || to_char(v_decimal));
  
  v_base_string := '-1';
  v_decimal := util_numeric.hextodec(v_base_string);
  dbms_output.put_line('HEXTODEC Hex = ' || v_base_string || ' Decimal = ' || to_char(v_decimal));
  
  v_base_string := '3E8';
  v_decimal := util_numeric.hextodec(v_base_string);
  dbms_output.put_line('HEXTODEC Hex = ' || v_base_string || ' Decimal = ' || to_char(v_decimal));
  
  v_base_string := '1A2F3G';
  v_decimal := util_numeric.hextodec(v_base_string);
  dbms_output.put_line('HEXTODEC Hex = ' || v_base_string || ' Decimal = ' || to_char(v_decimal));
  
  v_base := 8;
  
  v_decimal :=NULL;
  v_base_string := util_numeric.dectobase(v_decimal,v_base);
  dbms_output.put_line('DECTOBASE Decimal = NULL' || to_char(v_decimal) || ' BASE ' || to_char(v_base) || ' = ' || v_base_string);
  
  v_decimal :=0;
  v_base_string := util_numeric.dectobase(v_decimal,v_base);
  dbms_output.put_line('DECTOBASE Decimal = ' || to_char(v_decimal) || ' BASE ' || to_char(v_base) || ' = ' || v_base_string);

  v_decimal :=-1;
  v_base_string := util_numeric.dectobase(v_decimal,v_base);
  dbms_output.put_line('DECTOBASE Decimal = ' || to_char(v_decimal) || ' BASE ' || to_char(v_base) || ' = ' || v_base_string);
  
  v_decimal :=1000;
  v_base_string := util_numeric.dectobase(v_decimal,v_base);
  dbms_output.put_line('DECTOBASE Decimal = ' || to_char(v_decimal) || ' BASE ' || to_char(v_base) || ' = ' || v_base_string);
  
  v_base_string := NULL;
  v_decimal := util_numeric.basetodec(v_base_string,v_base);
  dbms_output.put_line('BASETODEC ' || v_base_string || 'NULL Base ' || to_char(v_base) || ' Decimal = ' || to_char(v_decimal));
  
  v_base_string := '0';
  v_decimal := util_numeric.basetodec(v_base_string,v_base);
  dbms_output.put_line('BASETODEC ' || v_base_string || ' Base ' || to_char(v_base) || ' Decimal = ' || to_char(v_decimal));

  v_base_string := '-1';
  v_decimal := util_numeric.basetodec(v_base_string,v_base);
  dbms_output.put_line('BASETODEC ' || v_base_string || ' Base ' || to_char(v_base) || ' Decimal = ' || to_char(v_decimal));
  
  v_base_string := '1750';
  v_decimal := util_numeric.basetodec(v_base_string,v_base);
  dbms_output.put_line('BASETODEC ' || v_base_string || ' Base ' || to_char(v_base) || ' Decimal = ' || to_char(v_decimal));
  
  v_base_string := '17508';
  v_decimal := util_numeric.basetodec(v_base_string,v_base);
  dbms_output.put_line('BASETODEC ' || v_base_string || ' Base ' || to_char(v_base) || ' Decimal = ' || to_char(v_decimal));
  
END;